from Ingredient import Ingredient

class Recipe:
    """
    Purpose:
        Class is used for every known recipe to be able to access or modify
        recipe information easily
    Instance variables:
        Recipe.recipes_dict: dictionary of all recipes in the format of
            {"name": recipe_object}
        self.name: name of recipe
        self.ingredients: dictionary of ingredients with name as key and
            a list of amount and unit as value ex. {Eggs: [3, 'Unit']}. Units can
            be ("Units", "Tsp", "Tbs", "Cup", "Lb")
        self.instructions: string of recipe instructions
        self.cost: total cost of recipe

    Methods:
        update_cost: takes the cost and unit of every ingredient
            that is used in the recipe and calulates the total cost of the recipe
        __str__: creates a string of the recipe and its information to be saved in
            a csv file.
    """

    recipes_dict = {}

    def __init__(self, name, ingredients, instructions, cost=None):
        self.name = name
        self.ingredients = ingredients
        self.instructions = instructions
        if cost == None:
            self.update_cost()
            for ingredient_name in tuple(self.ingredients.keys()):
                Ingredient.ingredients_dict[ingredient_name].recipes.add(self.name)
        else:
            self.cost = cost
        Recipe.recipes_dict[self.name] = self

    def update_cost(self):
        cost = 0
        for ingredient_name in self.ingredients:
            unit = self.ingredients[ingredient_name][1]
            if unit == "Unit":
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                )
            elif unit == "Tsp":
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                    / 6
                )
            elif unit == "Tbs":
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                    / 2
                )
            elif unit == "Cup":
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                    * 8
                )
            elif unit == "Lb":
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                    * 16
                )
            else:
                cost += (
                    Ingredient.ingredients_dict[ingredient_name].cost
                    * self.ingredients[ingredient_name][0]
                )
        self.cost = cost

    def __repr__(self):
        return f"{self.name}_recipe_object"

    def __str__(self) -> str:
        return (
            ",".join(
                [
                    '"' + str(x).replace('"', '""') + '"'
                    if "," in str(x) or '"' in str(x) or "\n" in str(x)
                    else str(x)
                    for x in [
                        self.name,
                        str(self.ingredients),
                        self.instructions,
                        self.cost,
                    ]
                ]
            )
            + "\n"
        )